clear();
clc();
close all;                              %Plots schlieen

%KONFIGURATION---------------------------------------------------------------------
Y                   = @(x) x/(1+x^4);  %Gleichung eingeben
obereGrenze         = 1.0;              %b
untereGrenze        = 0.0;              %a
Iterationsschritte  = 10;               %n
sKommastellenDouble = '%.20f';           %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%INITIALISIERUNG-------------------------------------------------------------------
aWERTETABELLE(1,1)=["i"];
for(i=0:1:Iterationsschritte)
   aWERTETABELLE(1,2+i)=strcat("R(i,",num2str(i),")"); 
end
aWERTETABELLE(2:Iterationsschritte+2,1:Iterationsschritte+2)="";

%BERECHNUNG------------------------------------------------------------------------
%Berechnung der Spalte P(i,0)
aWERTETABELLE(2,1)="0";
aWERTETABELLE(2,2)=num2str(((obereGrenze-untereGrenze)/2)*(Y(untereGrenze)+Y(obereGrenze)),sKommastellenDouble);
for(i=1:1:Iterationsschritte)
    dSCHRITTWEITE=(obereGrenze-untereGrenze)/(2^i);
    Zwischenspeicher=0;
    for(j=1:1:(2^(i-1)))
        Zwischenspeicher=Zwischenspeicher+Y(untereGrenze+(((2*j)-1)*dSCHRITTWEITE));
    end
    aWERTETABELLE(2+i,1)=num2str(i);
    aWERTETABELLE(2+i,2)=num2str((str2double(aWERTETABELLE(1+i,2))/2)+(dSCHRITTWEITE*Zwischenspeicher),sKommastellenDouble);
end
%Berechnung der folgenden Spalten
for(i=1:1:Iterationsschritte)%Spalten
    for(j=i:1:Iterationsschritte)
        aWERTETABELLE(2+j,2+i)=num2str((1/((4^i)-1))*(((4^i)*str2double(aWERTETABELLE(2+j,2+i-1)))-str2double(aWERTETABELLE(2+j-1,2+i-1))),sKommastellenDouble);
    end
end
disp(aWERTETABELLE);

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE                               %Workspace aufrumen